/*
 * MoveEffectInfo.h
 *
 * Created 8/30/2009 By Johnny Huynh
 *
 * Version 00.00.01 8/30/2009
 *
 * Copyright Information:
 * All content copyright  2009 Johnny Huynh. All rights reserved.
 */
 
 #ifndef MOVE_EFFECT_INFO_H
 #define MOVE_EFFECT_INFO_H
 
 template <typename T> class MoveEffectInfo;
 
 #include "global.h"
 
 #include "EffectInfo.h"
 #include "EffectTask.h"
 #include "pointerTo.h"
 
 /**
  * Class specification for MoveEffectInfo
  */
 template <typename T>
 class MoveEffectInfo : virtual public EffectInfo<T>
 {
 // Data Members
 private:
    double _duration;
    
 // Local Functions
 public:
    MoveEffectInfo( const double duration, EffectFunc* effect_func = &MoveEffectInfo<T>::process_move_effect );
    MoveEffectInfo( const MoveEffectInfo<T>& move_effect_info );
    virtual ~MoveEffectInfo();
    inline MoveEffectInfo<T>& operator=( const MoveEffectInfo<T>& move_effect_info );
    inline double get_move_duration() const;
    inline void set_move_duration( const double duration );
 
 // Private Functions
 private:
    
 // Static Functions
 public:
    
 };
 
 /** LOCAL FUNCTIONS **/
 
 /**
  * Constructor
  */
 template <typename T>
 MoveEffectInfo<T>::MoveEffectInfo( const double duration, EffectFunc* effect_func )
                   : EffectInfo<T>( effect_func ),
                     _duration( duration )
 {
    
 }
 
 /**
  * Copy Constructor
  */
 template <typename T>
 MoveEffectInfo<T>::MoveEffectInfo( const MoveEffectInfo<T>& move_effect_info )
                   : EffectInfo<T>( move_effect_info ),
                     _duration( move_effect_info._duration )
 {
    
 }
 
 /**
  * Destructor
  */
 template <typename T>
 MoveEffectInfo<T>::~MoveEffectInfo()
 {
    
 }
 
 /**
  * operator=() copies the content of the specified MoveEffectInfo to this MoveEffectInfo.
  *
  * @param (const MoveEffectInfo<T>&) move_effect_info
  * @return MoveEffectInfo<T>&
  */
 template <typename T>
 inline MoveEffectInfo<T>& MoveEffectInfo<T>::operator=( const MoveEffectInfo<T>& move_effect_info )
 {
    EffectInfo<T>::operator=( move_effect_info );
    _duration = move_effect_info._duration;
    
    return *this;
 }
 
 /**
  * get_move_duration() returns the movement duration.
  *
  * @return double
  */
 template <typename T>
 inline double MoveEffectInfo<T>::get_move_duration() const
 {
    return _duration;
 }
 
 /**
  * set_move_duration() sets the movement duration to the specified duration.
  *
  * @param (const double) duration
  */
 template <typename T>
 inline void MoveEffectInfo<T>::set_move_duration( const double duration )
 {
    _duration = duration;
 }
 
 /** STATIC FUNCTIONS **/
 
 #endif // MOVE_EFFECT_INFO_H